package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.functions.FunctionParameters
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FunctionParametersSerializer extends AstNodeSerializer[FunctionParameters] {

  override protected def doSerialize(node: FunctionParameters, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val paramList = FunctionParameterSerializer.serializeSeq(node.paramList)
    val children: Seq[SerializableAstNode] = Seq(_annotations, paramList)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_PARAMETERS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FunctionParameters = {
    val parameters = FunctionParameterSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    FunctionParameters(parameters)
  }
}
