package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.FunctionTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FunctionTypeNodeSerializer extends AstNodeSerializer[FunctionTypeNode] {

  override protected def doSerialize(node: FunctionTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val args = FunctionParameterTypeNodeSerializer.serializeSeq(node.args)
    val returnType = AstToSerializableMapper.serialize(node.returnType)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, args, returnType, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FunctionTypeNode = {
    val args = FunctionParameterTypeNodeSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    val returnType = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(4), srcResource, srcIdentifier)
    FunctionTypeNode(args, returnType, maybeSchema, maybeTypeSchema, annotations)
  }
}
