package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.HeadTailArrayNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object HeadTailArrayNodeSerializer extends AstNodeSerializer[HeadTailArrayNode] {

  override protected def doSerialize(node: HeadTailArrayNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val head = AstToSerializableMapper.serialize(node.head)
    val tail = AstToSerializableMapper.serialize(node.tail)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, head, tail, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.HEAD_TAIL_ARRAY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): HeadTailArrayNode = {
    val head = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val tail = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    HeadTailArrayNode(head, tail, annotations)
  }
}
