package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.HeadTailObjectNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object HeadTailObjectNodeSerializer extends AstNodeSerializer[HeadTailObjectNode] {

  override protected def doSerialize(node: HeadTailObjectNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val headKey = AstToSerializableMapper.serialize(node.headKey)
    val headValue = AstToSerializableMapper.serialize(node.headValue)
    val tail = AstToSerializableMapper.serialize(node.tail)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, headKey, headValue, tail, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.HEAD_TAIL_OBJECT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): HeadTailObjectNode = {
    val headKey = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val headValue = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val tail = AstToSerializableMapper.deserialize(children(2), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    HeadTailObjectNode(headKey, headValue, tail, annotations)
  }
}
