package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper.deserializeSeq
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object HeaderNodeSerializer extends AstNodeSerializer[HeaderNode] {

  override protected def doSerialize(node: HeaderNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val directives = AstToSerializableMapper.serializeSeq(node.directives)
    val children: Seq[SerializableAstNode] = Seq(_annotations, directives)
    NodeSerializableAstNode(SerializableAstNodeKind.HEADER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): HeaderNode = {
    val directives = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier).asInstanceOf[Seq[DirectiveNode]]
    HeaderNode(directives)
  }
}
