package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ImportDirectiveSerializer extends AstNodeSerializer[ImportDirective] {

  override protected def doSerialize(node: ImportDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val importedModule = ImportedElementSerializer.serialize(node.importedModule)
    val subElements = ImportedElementsSerializer.serialize(node.subElements)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, importedModule, subElements, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.IMPORT_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ImportDirective = {
    val importedModule = ImportedElementSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val subElements = ImportedElementsSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    ImportDirective(importedModule, subElements, annotations)
  }
}
