package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.header.directives.ImportedElement
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ImportedElementSerializer extends AstNodeSerializer[ImportedElement] {

  override protected def doSerialize(node: ImportedElement, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elementName = NameIdentifierSerializer.serialize(node.elementName)
    val alias = NameIdentifierSerializer.serializeMaybe(node.alias)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elementName, alias)
    NodeSerializableAstNode(SerializableAstNodeKind.IMPORTED_ELEMENT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ImportedElement = {
    val name = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val alias = NameIdentifierSerializer.deserializeMaybe(children(1), srcResource, srcIdentifier)
    ImportedElement(name, alias)
  }
}
