package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ImportedElementsSerializer extends AstNodeSerializer[ImportedElements] {

  override protected def doSerialize(node: ImportedElements, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elements = ImportedElementSerializer.serializeSeq(node.elements)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elements)
    NodeSerializableAstNode(SerializableAstNodeKind.IMPORTED_ELEMENTS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ImportedElements = {
    val elements = ImportedElementSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    ImportedElements(elements)
  }
}
