package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object InputDirectiveSerializer extends AstNodeSerializer[InputDirective] {

  override protected def doSerialize(node: InputDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val dataFormat = DataFormatIdSerializer.serializeMaybe(node.dataFormat)
    val mime = ContentTypeSerializer.serializeMaybe(node.mime)
    val options = DirectiveOptionSerializer.serializeMaybeSeq(node.options)
    val wtype = AstToSerializableMapper.serializeMaybe(node.wtype)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, dataFormat, mime, options, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.INPUT_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): InputDirective = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val dataFormat = DataFormatIdSerializer.deserializeMaybe(children(1), srcResource, srcIdentifier)
    val mime = ContentTypeSerializer.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val options = DirectiveOptionSerializer.deserializeMaybeSeq(children(3), srcResource, srcIdentifier)
    val wtype = AstToSerializableMapper.deserializeMaybe(children(4), srcResource, srcIdentifier).asInstanceOf[Option[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(5), srcResource, srcIdentifier)
    InputDirective(identifier, dataFormat, mime, options, wtype, annotations)
  }
}
