package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.KeyNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object KeyNodeSerializer extends AstNodeSerializer[KeyNode] {

  override protected def doSerialize(node: KeyNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val ns = AstToSerializableMapper.serializeMaybe(node.ns)
    val attr = AstToSerializableMapper.serializeMaybe(node.attr)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName, ns, attr, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.KEY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): KeyNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val ns = AstToSerializableMapper.deserializeMaybe(children(1), srcResource, srcIdentifier)
    val attr = AstToSerializableMapper.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    KeyNode(keyName, ns, attr, annotations)
  }
}
