package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.KeyTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object KeyTypeNodeSerializer extends AstNodeSerializer[KeyTypeNode] {

  override protected def doSerialize(node: KeyTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameTypeNodeSerializer.serialize(node.name)
    val attrs = AstToSerializableMapper.serializeSeq(node.attrs)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, attrs, annotations, maybeSchema, maybeTypeSchema)
    NodeSerializableAstNode(SerializableAstNodeKind.KEY_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): KeyTypeNode = {
    val name = NameTypeNodeSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val attrs = AstToSerializableMapper.deserializeSeq(children(1), srcResource, srcIdentifier).asInstanceOf[Seq[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), srcResource, srcIdentifier)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(4), srcResource, srcIdentifier)
    KeyTypeNode(name, attrs, annotations, maybeSchema, maybeTypeSchema)
  }
}
