package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.KeyValueTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object KeyValueTypeNodeSerializer extends AstNodeSerializer[KeyValueTypeNode] {

  override protected def doSerialize(node: KeyValueTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val key = AstToSerializableMapper.serialize(node.key)
    val value = AstToSerializableMapper.serialize(node.value)
    val repeated = serializeBoolean(node.repeated)
    val optional = serializeBoolean(node.optional)
    val children: Seq[SerializableAstNode] = Seq(_annotations, key, value, repeated, optional)
    NodeSerializableAstNode(SerializableAstNodeKind.KEY_VALUE_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): KeyValueTypeNode = {
    val key = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val value = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val repeated = deserializeBoolean(children(2))
    val optional = deserializeBoolean(children(3))
    KeyValueTypeNode(key, value, repeated, optional)
  }
}
