package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.LiteralTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object LiteralTypeNodeSerializer extends AstNodeSerializer[LiteralTypeNode] {

  override protected def doSerialize(node: LiteralTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = AstToSerializableMapper.serialize(node.value)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.LITERAL_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): LiteralTypeNode = {
    val value = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(1), srcResource, srcIdentifier)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    LiteralTypeNode(value, maybeSchema, maybeTypeSchema, annotations)
  }
}
