package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ModuleNodeSerializer extends AstNodeSerializer[ModuleNode] {

  override protected def doSerialize(node: ModuleNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val elements = AstToSerializableMapper.serializeSeq(node.elements)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, elements)
    NodeSerializableAstNode(SerializableAstNodeKind.MODULE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ModuleNode = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val elements = AstToSerializableMapper.deserializeSeq(children(1), srcResource, srcIdentifier).asInstanceOf[Seq[DirectiveNode]]
    ModuleNode(identifier, elements)
  }
}
