package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NameIdentifierSerializer extends AstNodeSerializer[NameIdentifier] {

  override protected def doSerialize(node: NameIdentifier, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = serializeString(node.name)
    val loader = serializerMaybeString(node.loader)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, loader)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_IDENTIFIER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NameIdentifier = {
    val name = deserializeString(children.head)
    val loader = deserializeMaybeString(children(1))
    NameIdentifier(name, loader)
  }
}
