package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.NameNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NameNodeSerializer extends AstNodeSerializer[NameNode] {

  override protected def doSerialize(node: NameNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val ns = AstToSerializableMapper.serializeMaybe(node.ns)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName, ns, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NameNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val ns = AstToSerializableMapper.deserializeMaybe(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    NameNode(keyName, ns, annotations)
  }
}
