package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.NameValuePairNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NameValuePairNodeSerializer extends AstNodeSerializer[NameValuePairNode] {

  override protected def doSerialize(node: NameValuePairNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val key = AstToSerializableMapper.serialize(node.key)
    val value = AstToSerializableMapper.serialize(node.value)
    val cond = AstToSerializableMapper.serializeMaybe(node.cond)
    val children: Seq[SerializableAstNode] = Seq(_annotations, key, value, cond)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_VALUE_PAIR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NameValuePairNode = {
    val key = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val value = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val cond = AstToSerializableMapper.deserializeMaybe(children(2), srcResource, srcIdentifier)
    NameValuePairNode(key, value, cond)
  }
}
