package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.NameValueTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NameValueTypeNodeSerializer extends AstNodeSerializer[NameValueTypeNode] {

  override protected def doSerialize(node: NameValueTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameTypeNodeSerializer.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val optional = serializeBoolean(node.optional)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, value, optional)
    NodeSerializableAstNode(SerializableAstNodeKind.NAME_VALUE_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NameValueTypeNode = {
    val name = NameTypeNodeSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val value = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val optional = deserializeBoolean(children(2))
    NameValueTypeNode(name, value, optional)
  }
}
