package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NamespaceDirectiveSerializer extends AstNodeSerializer[NamespaceDirective] {

  override protected def doSerialize(node: NamespaceDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val prefix = NameIdentifierSerializer.serialize(node.prefix)
    val uri = UriNodeSerializer.serialize(node.uri)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, prefix, uri, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NAMESPACE_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NamespaceDirective = {
    val prefix = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val uri = UriNodeSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    NamespaceDirective(prefix, uri, annotations)
  }
}
