package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.structure.NamespaceNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NamespaceNodeSerializer extends AstNodeSerializer[NamespaceNode] {

  override protected def doSerialize(node: NamespaceNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val prefix = NameIdentifierSerializer.serialize(node.prefix)
    val children: Seq[SerializableAstNode] = Seq(_annotations, prefix)
    NodeSerializableAstNode(SerializableAstNodeKind.NAMESPACE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NamespaceNode = {
    val prefix = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    NamespaceNode(prefix)
  }
}
