package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.parser.ast.types.NativeTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NativeTypeNodeSerializer extends AstNodeSerializer[NativeTypeNode] {

  override protected def doSerialize(node: NativeTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val typeId = serializeString(node.typeId)
    val asSchema = SchemaNodeSerializer.serializeMaybe(node.asSchema)
    val children: Seq[SerializableAstNode] = Seq(_annotations, typeId, asSchema)
    NodeSerializableAstNode(SerializableAstNodeKind.NATIVE_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NativeTypeNode = {
    val typeId = deserializeString(children.head)
    val asSchema = SchemaNodeSerializer.deserializeMaybe(children(1), srcResource, srcIdentifier)
    NativeTypeNode(typeId, asSchema)
  }
}
