package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.selectors.NullUnSafeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object NullUnSafeNodeSerializer extends AstNodeSerializer[NullUnSafeNode] {

  override protected def doSerialize(node: NullUnSafeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = AstToSerializableMapper.serialize(node.selector)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NULL_UNSAFE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): NullUnSafeNode = {
    val selector = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), srcResource, srcIdentifier)
    NullUnSafeNode(selector, annotations)
  }
}
