package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.ObjectNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ObjectNodeSerializer extends AstNodeSerializer[ObjectNode] {

  override protected def doSerialize(node: ObjectNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elements = AstToSerializableMapper.serializeSeq(node.elements)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elements, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.OBJECT_LITERAL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ObjectNode = {
    val elements = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), srcResource, srcIdentifier)
    ObjectNode(elements, annotations)
  }
}
