package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ObjectTypeNodeSerializer extends AstNodeSerializer[ObjectTypeNode] {

  override protected def doSerialize(node: ObjectTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val properties = AstToSerializableMapper.serializeSeq(node.properties)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val closed = serializeBoolean(node.close)
    val ordered = serializeBoolean(node.ordered)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, properties, maybeSchema, maybeTypeSchema, closed, ordered, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.OBJECT_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ObjectTypeNode = {
    val properties = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier).asInstanceOf[Seq[WeaveTypeNode]]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(1), srcResource, srcIdentifier)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val closed = deserializeBoolean(children(3))
    val ordered = deserializeBoolean(children(4))
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(5), srcResource, srcIdentifier)
    ObjectTypeNode(properties, maybeSchema, maybeTypeSchema, closed, ordered, annotations)
  }
}
