package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object OverloadedFunctionNodeSerializer extends AstNodeSerializer[OverloadedFunctionNode] {

  override protected def doSerialize(node: OverloadedFunctionNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val directives = FunctionDirectiveNodeSerializer.serializeSeq(node.functionDirectives)
    val children: Seq[SerializableAstNode] = Seq(_annotations, directives)
    NodeSerializableAstNode(SerializableAstNodeKind.OVERLOADED_FUNCTION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): OverloadedFunctionNode = {
    val directives = FunctionDirectiveNodeSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    OverloadedFunctionNode(directives)
  }
}
