package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.patterns.PatternExpressionNode
import org.mule.weave.v2.parser.ast.patterns.PatternExpressionsNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object PatternExpressionsNodeSerializer extends AstNodeSerializer[PatternExpressionsNode] {

  override protected def doSerialize(node: PatternExpressionsNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val patterns = AstToSerializableMapper.serializeSeq(node.patterns)
    val children: Seq[SerializableAstNode] = Seq(_annotations, patterns)
    NodeSerializableAstNode(SerializableAstNodeKind.PATTERN_EXPRESSIONS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): PatternExpressionsNode = {
    val patterns = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier).asInstanceOf[Seq[PatternExpressionNode]]
    PatternExpressionsNode(patterns)
  }
}
