package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.patterns.PatternMatcherNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object PatternMatcherNodeSerializer extends AstNodeSerializer[PatternMatcherNode] {

  override protected def doSerialize(node: PatternMatcherNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val lhs = AstToSerializableMapper.serialize(node.lhs)
    val patterns = PatternExpressionsNodeSerializer.serialize(node.patterns)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, lhs, patterns, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.PATTERN_MATCHER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): PatternMatcherNode = {
    val lhs = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val patterns = PatternExpressionsNodeSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    PatternMatcherNode(lhs, patterns, annotations)
  }
}
