package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object SchemaNodeSerializer extends AstNodeSerializer[SchemaNode] {

  override protected def doSerialize(node: SchemaNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val properties = SchemaPropertyNodeSerializer.serializeSeq(node.properties)
    val children: Seq[SerializableAstNode] = Seq(_annotations, properties)
    NodeSerializableAstNode(SerializableAstNodeKind.SCHEMA_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): SchemaNode = {
    val properties = SchemaPropertyNodeSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    SchemaNode(properties)
  }
}
