package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.schema.SchemaPropertyNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object SchemaPropertyNodeSerializer extends AstNodeSerializer[SchemaPropertyNode] {

  override protected def doSerialize(node: SchemaPropertyNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = AstToSerializableMapper.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val condition = AstToSerializableMapper.serializeMaybe(node.condition)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, value, condition)
    NodeSerializableAstNode(SerializableAstNodeKind.SCHEMA_PROPERTY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): SchemaPropertyNode = {
    val name = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val value = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val condition = AstToSerializableMapper.deserializeMaybe(children(2), srcResource, srcIdentifier)
    SchemaPropertyNode(name, value, condition)
  }
}
