package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.StringInterpolationNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object StringInterpolationNodeSerializer extends AstNodeSerializer[StringInterpolationNode] {

  override protected def doSerialize(node: StringInterpolationNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elements = AstToSerializableMapper.serializeSeq(node.elements)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elements)
    NodeSerializableAstNode(SerializableAstNodeKind.STRING_INTERPOLATION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): StringInterpolationNode = {
    val elements = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier)
    StringInterpolationNode(elements)
  }
}
