package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.parser.ast.structure.TimeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TimeNodeSerializer extends AstNodeSerializer[TimeNode] {

  override protected def doSerialize(node: TimeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = serializeString(node.literalValue)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.TIME_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TimeNode = {
    val value = deserializeString(children.head)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), srcResource, srcIdentifier)
    TimeNode(value, annotations)
  }
}
