package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TypeDirectiveSerializer extends AstNodeSerializer[TypeDirective] {

  override protected def doSerialize(node: TypeDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val typeParams = TypeParametersListNodeSerializer.serializeMaybe(node.typeParametersListNode)
    val wtype = AstToSerializableMapper.serialize(node.typeExpression)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, typeParams, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TypeDirective = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val typeParamsList = TypeParametersListNodeSerializer.deserializeMaybe(children(1), srcResource, srcIdentifier)
    val typeExpression = AstToSerializableMapper.deserialize(children(2), srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    TypeDirective(identifier, typeParamsList, typeExpression, annotations)
  }
}
