package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.TypeParameterNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TypeParameterNodeSerializer extends AstNodeSerializer[TypeParameterNode] {

  override protected def doSerialize(node: TypeParameterNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val base = AstToSerializableMapper.serializeMaybe(node.base)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, base)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PARAMETER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TypeParameterNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val base = AstToSerializableMapper.deserializeMaybe(children(1), srcResource, srcIdentifier).asInstanceOf[Option[WeaveTypeNode]]
    TypeParameterNode(name, base)
  }
}
