package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.TypeParametersApplicationListNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TypeParametersApplicationListNodeSerializer extends AstNodeSerializer[TypeParametersApplicationListNode] {

  override protected def doSerialize(node: TypeParametersApplicationListNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val typeParameters = AstToSerializableMapper.serializeSeq(node.typeParameters)
    val children: Seq[SerializableAstNode] = Seq(_annotations, typeParameters)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PARAMETERS_APPLICATION_LIST_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TypeParametersApplicationListNode = {
    val typeParameters = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier).asInstanceOf[Seq[WeaveTypeNode]]
    TypeParametersApplicationListNode(typeParameters)
  }
}
