package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.types.TypeParametersListNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TypeParametersListNodeSerializer extends AstNodeSerializer[TypeParametersListNode] {

  override protected def doSerialize(node: TypeParametersListNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val typeParameters = TypeParameterNodeSerializer.serializeSeq(node.typeParameters)
    val children: Seq[SerializableAstNode] = Seq(_annotations, typeParameters)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PARAMETERS_LIST_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TypeParametersListNode = {
    val typeParameters = TypeParameterNodeSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    TypeParametersListNode(typeParameters)
  }
}
