package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.patterns.TypePatternNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TypePatternNodeSerializer extends AstNodeSerializer[TypePatternNode] {

  override protected def doSerialize(node: TypePatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val pattern = AstToSerializableMapper.serialize(node.pattern)
    val name = NameIdentifierSerializer.serialize(node.name)
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, pattern, name, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TypePatternNode = {
    val pattern = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val name = NameIdentifierSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val onMatch = AstToSerializableMapper.deserialize(children(2), srcResource, srcIdentifier)
    TypePatternNode(pattern, name, onMatch)
  }
}
