package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TypeReferenceNodeSerializer extends AstNodeSerializer[TypeReferenceNode] {

  override protected def doSerialize(node: TypeReferenceNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val typeArguments = AstToSerializableMapper.serializeMaybeSeq(node.typeArguments)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, typeArguments, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_REFERENCE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TypeReferenceNode = {
    val variable = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val typeArguments = AstToSerializableMapper.deserializeMaybeSeq(children(1), srcResource, srcIdentifier).asInstanceOf[Option[Seq[WeaveTypeNode]]]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(4), srcResource, srcIdentifier)
    TypeReferenceNode(variable, typeArguments, maybeSchema, maybeTypeSchema, annotations)
  }
}
