package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.TypeSelectorNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object TypeSelectorNodeSerializer extends AstNodeSerializer[TypeSelectorNode] {

  override protected def doSerialize(node: TypeSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = NameNodeSerializer.serialize(node.selector)
    val wtype = AstToSerializableMapper.serialize(node.weaveTypeNode)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, wtype, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): TypeSelectorNode = {
    val selector = NameNodeSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val wtype = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(4), srcResource, srcIdentifier)
    TypeSelectorNode(selector, wtype, maybeSchema, maybeTypeSchema, annotations)
  }
}
