package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.compilation.mapper.nonAst.OpIdSerializer
import org.mule.weave.v2.grammar.UnaryOpIdentifier
import org.mule.weave.v2.parser.ast.operators.UnaryOpNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object UnaryOpNodeSerializer extends AstNodeSerializer[UnaryOpNode] {

  override protected def doSerialize(node: UnaryOpNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val opId = OpIdSerializer.serialize(node.opId)
    val rhs = AstToSerializableMapper.serialize(node.rhs)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, opId, rhs, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.UNARY_OP_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): UnaryOpNode = {
    val op = OpIdSerializer.deserialize(children.head, srcResource, srcIdentifier).asInstanceOf[UnaryOpIdentifier]
    val rhs = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    UnaryOpNode(op, rhs, annotations)
  }
}
