package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.conditional.UnlessNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object UnlessNodeSerializer extends AstNodeSerializer[UnlessNode] {

  override protected def doSerialize(node: UnlessNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val ifExpr = AstToSerializableMapper.serialize(node.ifExpr)
    val condition = AstToSerializableMapper.serialize(node.condition)
    val elseExpr = AstToSerializableMapper.serialize(node.elseExpr)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, ifExpr, condition, elseExpr, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.UNLESS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): UnlessNode = {
    val ifExpr = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val condition = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val elseExpr = AstToSerializableMapper.deserialize(children(2), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    UnlessNode(ifExpr, condition, elseExpr, annotations)
  }
}
