package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object UpdateExpressionNodeSerializer extends AstNodeSerializer[UpdateExpressionNode] {

  override protected def doSerialize(node: UpdateExpressionNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val indexId = NameIdentifierSerializer.serialize(node.indexId)
    val selector = AstToSerializableMapper.serialize(node.selector)
    val forceCreate = serializeBoolean(node.forceCreate)
    val condition = AstToSerializableMapper.serializeMaybe(node.condition)
    val updateExpression = AstToSerializableMapper.serialize(node.updateExpression)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, indexId, selector, forceCreate, condition, updateExpression)
    NodeSerializableAstNode(SerializableAstNodeKind.UPDATE_EXPRESSION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): UpdateExpressionNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val indexId = NameIdentifierSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val selector = AstToSerializableMapper.deserialize(children(2), srcResource, srcIdentifier)
    val forceCreate = deserializeBoolean(children(3))
    val condition = AstToSerializableMapper.deserializeMaybe(children(4), srcResource, srcIdentifier)
    val updateExpression = AstToSerializableMapper.deserialize(children(5), srcResource, srcIdentifier)
    UpdateExpressionNode(name, indexId, selector, forceCreate, condition, updateExpression)
  }
}
