package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionsNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object UpdateExpressionsNodeSerializer extends AstNodeSerializer[UpdateExpressionsNode] {

  override protected def doSerialize(node: UpdateExpressionsNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val expressions = UpdateExpressionNodeSerializer.serializeSeq(node.expressions)
    val children: Seq[SerializableAstNode] = Seq(_annotations, expressions)
    NodeSerializableAstNode(SerializableAstNodeKind.UPDATE_EXPRESSIONS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): UpdateExpressionsNode = {
    val expressions = UpdateExpressionNodeSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    UpdateExpressionsNode(expressions)
  }
}
