package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.updates.UpdateNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object UpdateNodeSerializer extends AstNodeSerializer[UpdateNode] {

  override protected def doSerialize(node: UpdateNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val expression = AstToSerializableMapper.serialize(node.expression)
    val matchers = UpdateExpressionsNodeSerializer.serialize(node.matchers)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, expression, matchers, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.UPDATE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): UpdateNode = {
    val expression = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val matchers = UpdateExpressionsNodeSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    UpdateNode(expression, matchers, annotations)
  }
}
