package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.functions.UsingNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object UsingNodeSerializer extends AstNodeSerializer[UsingNode] {

  override protected def doSerialize(node: UsingNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val assignments = UsingVariableAssignmentsSerializer.serialize(node.assignments)
    val expr = AstToSerializableMapper.serialize(node.expr)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, assignments, expr, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.USING_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): UsingNode = {
    val assignments = UsingVariableAssignmentsSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val expr = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    UsingNode(assignments, expr, annotations)
  }
}
