package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignments
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object UsingVariableAssignmentsSerializer extends AstNodeSerializer[UsingVariableAssignments] {

  override protected def doSerialize(node: UsingVariableAssignments, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val assignmentSeq = UsingVariableAssignmentSerializer.serializeSeq(node.assignmentSeq)
    val children: Seq[SerializableAstNode] = Seq(_annotations, assignmentSeq)
    NodeSerializableAstNode(SerializableAstNodeKind.USING_VARIABLE_ASSIGNMENTS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): UsingVariableAssignments = {
    val assignmentSeq = UsingVariableAssignmentSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    UsingVariableAssignments(assignmentSeq)
  }
}
