package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object VarDirectiveSerializer extends AstNodeSerializer[VarDirective] {

  override protected def doSerialize(node: VarDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val value = AstToSerializableMapper.serialize(node.value)
    val wtype = AstToSerializableMapper.serializeMaybe(node.wtype)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, value, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.VAR_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): VarDirective = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val value = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val wtype = AstToSerializableMapper.deserializeMaybe(children(2), srcResource, srcIdentifier).asInstanceOf[Option[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    VarDirective(identifier, value, wtype, annotations)
  }
}
