package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.sdk.WeaveResource

object VariableReferenceNodeSerializer extends AstNodeSerializer[VariableReferenceNode] {

  override protected def doSerialize(node: VariableReferenceNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.VARIABLE_REFERENCE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): VariableReferenceNode = {
    val variable = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), srcResource, srcIdentifier)
    VariableReferenceNode(variable, annotations)
  }
}
