package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object VersionDirectiveSerializer extends AstNodeSerializer[VersionDirective] {

  override protected def doSerialize(node: VersionDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val major = VersionMajorSerializer.serialize(node.major)
    val minor = VersionMinorSerializer.serialize(node.minor)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, major, minor, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.VERSION_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): VersionDirective = {
    val major = VersionMajorSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val minor = VersionMinorSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    VersionDirective(major, minor, annotations)
  }
}
