package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.parser.ast.header.directives.VersionMinor
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object VersionMinorSerializer extends AstNodeSerializer[VersionMinor] {

  override protected def doSerialize(node: VersionMinor, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val children: Seq[SerializableAstNode] = Seq(_annotations, serializeString(node.v))
    NodeSerializableAstNode(SerializableAstNodeKind.VERSION_MINOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): VersionMinor = {
    val v = deserializeString(children.head)
    VersionMinor(v)
  }
}
