package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.UnknownLocation
import org.mule.weave.v2.compilation.mapper.DWSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.interpreted.marker.InterceptorNativeFunctionValue
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object InterceptorNativeFunctionValueSerializer extends DWSerializer[InterceptorNativeFunctionValue] {

  override def serialize(nativeFunctionValue: InterceptorNativeFunctionValue): SerializableAstNode = {
    val children = Seq(
      NameIdentifierSerializer.serialize(nativeFunctionValue.functionName),
      NoSourceLocationValueSerializer.serializeMaybe(nativeFunctionValue.location))
    NodeSerializableAstNode(SerializableAstNodeKind.INTERCEPTOR_NATIVE_FUNCTION_VALUE_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, resource: WeaveResource, identifier: NameIdentifier): InterceptorNativeFunctionValue = {
    val functionName = NameIdentifierSerializer.deserialize(node.children().head, resource, identifier)
    val location = NoSourceLocationValueSerializer.deserializeMaybe(node.children()(1), resource, identifier)
    InterceptorNativeFunctionValue(functionName, location)
  }
}
